import time
import asyncio
import telnetlib3

host = '127.0.0.1'
port = '1248'

commands = [
    ( 'asdf' ),
    ( '?' ),
    ( '? rds.1.tp' ),
    ( '? set' ),
    ( 'set' ),
    ( '? channel.1.freq' ),
    ( 'get channel.1' ),
    ( 'get channel.2,4-6,9.freq' ),
    ( 'set channel.1.used 0' ),
    ( 'set channel.1.freq 96.300' ),
    ( 'set channel.1.gain -20' ),
    ( 'set channel.1.used 1' ),
    ( 'set channel.1.gain -10' ),
    ( None )
]

async def main():
    try:
        reader, writer = await telnetlib3.open_connection(host, port)

        itcmd = iter(commands)
        cmdtime = time.monotonic() + 1 # send next command in 1 second

        while True: # read info and send commands
            try:
                data = await asyncio.wait_for(reader.readline(), timeout=0.2)
                print(data.strip())
            except asyncio.exceptions.TimeoutError:
                pass

            now = time.monotonic()
            if now > cmdtime:
                cmdtime = now + 0.5 # next command in a half second
                cmd = next(itcmd)
                if not cmd: break   # no more commands
                writer.write(cmd + '\r\n')
                print('\n' + cmd)

    except:
        print('could not connect to MultiFM Generator @ ' + host + ':' + port)
        pass

    print('\nmain exit')

asyncio.run(main())

print('done')
